# ABM caller with some handy statements for using the model

# Load the model ready for use
# Use the R menu above to change the working directory of R to the folder where the ABM model R script is stored.
# You have to click on the console to make it the active window, then go to File, and Change dir.... Then use:
source("ABM ver 3_0.R")

# set up fonts
library(extrafont)
font_import()
fonts()			# shows fonts available
fonttable()			# shows more information about fonts available
loadfonts()
loadfonts(device = "win")

# run one trial
run_trial()
plot(days$id,days$ccr, type="l", main="Exchange rate over time (single trial)", xlab="Days", ylab="Exchange rate")
plot(days$id, days$ccheldbyRE, type="l", main="CC held x relative entropy (excluding exchange)", xlab="Days", ylab="adj CC")
plot(days$id, days$purchbyRE, type="l", main="Commercial activity x relative entropy (excluding exchange)", xlab="Days", ylab="adj CC")
plot(days$id, days$excbyRE, type="l", main="Exchange activity x relative entropy", xlab="Days", ylab="adj CC")
plot(days$id, days$merccex + days$cusccex, type="l", main="Merchant + customer exchange total", xlab="Days", ylab="adj CC")
plot(days$id, days$cusin + days$merin, type="l", main="Customers and merchants participating", xlab="Days", ylab="Count")
plot(days$id, days$cusmint + days$mermint, type="l", main="Amount minted", xlab="Days", ylab="CC")
plot(days$id,days$purchRE, type="l", main="Relative entropy of CC purchases", xlab="Days", ylab="RE")
plot(days$id,days$heldRE, type="l", main="Relative entropy of CC holdings", xlab="Days", ylab="RE")


# shows how cc purchases start when there is a zero or negative trend on prices
plot(ewma_delta(days$ccr, 0.05, "t"), days$purchbyRE, main="Downward exchange rate trend triggers customers buying in CC", xlab="EWMA of exchange rate differences", ylab="Purchases in CC x relative entropy")  # shows when commercial activity cuts in

# shows fc purchases and cc purchases on same graph
plot(days$fcpurch, type="l", ylim=c(0,200))
lines(days$ccpurch, type="l", col="red")

# shows pool and total cc on one chart
plot(days$pool, type="l", ylim=c(0,20000), main="Total CC (red) and pool (black)", xlab="Days", ylab="CC")
lines(days$totalcc, type="l", col="red")

plot(days$pool, type="l")
lines(days$totalcc, type="l", col="red")


plot(days$cusin+days$merin, days$excbyRE)
plot(days$cusin+days$merin, days$purchbyRE)
plot(days$cusin+days$merin, days$ccheldbyRE)


# See the parameters used
params

# see the history of the latest trial
days

# run a monte carlo simulation
run_sim()
trials
hist(trials$fccr, breaks=20)
plot(table(round(trials$fccr, digits=2)), main="Final exchange rate (100 trials)", xlab="Exchange rate", ylab="Frequency")

# run the experiment - VERY SLOW!
run_expt1()
run_expt2()
hist(trials1$fccr, breaks=20)
hist(trials2$fccr, breaks=20)
plot(table(round(trials1$fccr, digits=2)), main="Final exchange rate distribution - few prices set monthly", xlab="Exchange rate", ylab="Frequency", xlim=c(0.7, 1.8))
plot(table(round(trials2$fccr, digits=2)), main="Final exchange rate distribution - many prices set monthly", xlab="Exchange rate", ylab="Frequency", xlim=c(0.7, 1.8))
sd(trials1$fccr)
sd(trials2$fccr)
mean(trials1$fccr)
mean(trials2$fccr)

btc <- read.csv("C:/Users/Sarah Watkins/Documents/work/Consulting clients/zyen/dascoin project/BAVERAGE-EUR.csv", head=TRUE)	# read in data file

write.csv(days$ccheldre, "C:/Users/Sarah Watkins/Documents/work/Consulting clients/zyen/dascoin project/ccheldre_series.csv", row.names=FALSE)	# write .csv file
t <- read.csv("C:/Users/Sarah Watkins/Documents/work/Consulting clients/zyen/dascoin project/ccheldre_series.csv", head=TRUE)	# read in data file and assign to a data frame

plot(t$x, type="l")



# FOR PUBLICATION

# initial set up
r_seed <- -1			# random seed; -1 means use the default
m_max <- 10  			# number of merchants
m_gnave <- 5			# average number of goods offered per merchant
m_gnineq <- 1			# inequality factor; the s in 1/k^s. 0.25 is almost flat, 4 is almost all goods for first supplier
m_pave <- 3				# average price of first good for a merchant
m_pineq <- 1			# inequality factor for price of first good for each merchant
c_max <- 40				# number of customers
c_pave <- 3				# average number of purchases per day for each customer
c_pineq <- 1			# inequality factor for number of purchases per day per customer; 0.25 is nearly flat; 4 is very, very skewed. The s in 1/k^s.
ccr_start <- 1			# initial FC/CC rate i.e. FC per CC, the price of one unit of CC in NCs
cc_fxl <- 0.03			# fraction of currency lost in a round trip (FC to CC to FC) due to bid-ask spread
ccm_start <- 100			# initial minting cost of a unit of CC, expressed in FC
pool_start <- 5000 		# initial CC pool held by the currency exchange
buzz_start <- 10			# initial buzz level
t_days <- 730			# number of days to simulate in one trial
s_trials <- 100			# number of trials to use in MC simulation
fmask <- c(1,1,1,1,1,1)		# mask for factors; 0 will take the factor out of consideration
rcncy <- c(0,0.1)			# range for recency factors

# exchange decisions
exc_type <- 9			# exchange mechanism choice
exc_width <- 12000		# width parameter over which multiplier varies - intended range of pool
exc_greatest <- 5			# controls max size of multiplier (at zero)
exc_peak <- 200			# also controls max size of multiplier (at zero)
exc_damp <- 2000			# overall strength of multiplier over whole range

# merchant decisions
m_now_prob <- 0.1			# probability of choosing to set 'now' prices, given opting in
m_wkly_prob <- 0.2		# probability of choosing weekly prices, given not setting 'now' prices (alternative is monthly prices)
m_lambda <- 0.3			# lambda for EWMA of sentiment
m_unitsales <- 10			# daily sales in CC prices that yields sentiment of 1 for the day
m_unitbuzz <- 10			# level of buzz that yields sentiment of 1 for the day
m_sbfrac <- 0.5			# proportion of sentiment contributed by sales each day
m_pot_mult <- 10			# multiplier used to set merchants' cashpots

# customer decisions
c_lambda <- 0.1			# lambda for EWMA used for sentiment
c_unitsav <- 10			# daily savings through choosing CC prices that yields sentiment of 1 for the day
c_unitbuzz <- 10			# level of buzz that yields sentiment of 1 for the day
c_sbfrac <- 0.5			# proportion of sentiment contributed by savings each day
c_pot_mult <- 20			# multiplier used to set customers' cashpots


# 1. uncapped, damp=2000

s_trials <- 100
exc_type <- 9
exc_width <- 12000		# width parameter over which multiplier varies - intended range of pool
exc_greatest <- 5			# controls max size of multiplier (at zero)
exc_peak <- 200			# also controls max size of multiplier (at zero)
exc_damp <- 2000			# overall strength of multiplier over whole range
ccm_start <- 10
run_sim()

write.csv(trials, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE.csv", row.names=FALSE)	# write .csv file
trials1 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE.csv", head=TRUE)	# read in data file

write.csv(days, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE.csv", row.names=FALSE)	# write .csv file
days1 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE.csv", head=TRUE)	# read in data file

trials1$poolmin[trials1$poolmin < 0]
hist(trials1$fccr[trials1$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,10), ylim=c(0,15), main="")
hist(trials1$poolmin, breaks=20, xlab="Minimum pool", main="")
hist(trials1$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days1$id, days1$ccr, type="l", main="", xlab="Day", ylab="Exchange rate")
plot(days1$id, days1$pool, type="l", main="", xlab="Day", ylab="Exchange rate")
plot(days1$id, days1$totalcc, type="l", main="", xlab="Day", ylab="Exchange rate")

mean(trials1$fccr)		# 5.37417
mean(trials1$maxccr)		# 5.377222
mean(trials1$minccr)		# 1
mean(trials1$aveccr)		# 2.556376
mean(trials1$sd)			# 1.249544
mean(trials1$fd)			# 1.047241
mean(trials1$runave)		# 0.03451874
mean(trials1$diffave)		# 0.008111453
mean(trials1$poolmax)		# 4934.371
mean(trials1$poolmin)		# 338.5653
sum(trials1$poolout)		# 0
mean(trials1$totalcc)		# 5000

sd(trials1$fccr)			# 1.052006
sd(trials1$maxccr)		# 1.053795
sd(trials1$minccr)		# 0
sd(trials1$aveccr)		# 0.3106641
sd(trials1$sd)			# 0.2959606
sd(trials1$fd)			# 0.02185958
sd(trials1$runave)		# 0.01848531
sd(trials1$diffave)		# 0.002244247
sd(trials1$poolmax)		# 199.4357
sd(trials1$poolmin)		# 147.8534
sd(trials1$totalcc)		# 0

quantile(trials1$fccr, c(0.05, 0.95))	# 4.167622 7.627313 
quantile(trials1$maxccr, c(0.05, 0.95))	# 4.167622 7.652381 
quantile(trials1$minccr, c(0.05, 0.95))	# 1 1
quantile(trials1$aveccr, c(0.05, 0.95))	# 2.173541 3.141926 
quantile(trials1$sd, c(0.05, 0.95))		# 0.9098177 1.8437548 
quantile(trials1$fd, c(0.05, 0.95))		# 1.016284 1.086398
quantile(trials1$runave, c(0.05, 0.95))	# 0.01821728 0.07740173 
quantile(trials1$diffave, c(0.05, 0.95))	# 0.005228782 0.012859717 
quantile(trials1$poolmax, c(0.05, 0.95))	# 4670.882 5000.000 
quantile(trials1$poolmin, c(0.05, 0.95))	#  98.63775 602.51598 
quantile(trials1$totalcc, c(0.05, 0.95))	# 5000 5000

tiff("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/Fig 2 uncapped.tiff", height = 7.5, width = 15, units = 'cm', compression = "lzw", res = 600)
	old.par <- par(no.readonly = TRUE)
	par(cex=0.6)
	par(mar=c(5.1,4.1,2.1,2.1))
	par(yaxp=c(0,1,5))

	hist(trials1$fccr[trials1$poolmin >= 0], breaks=20, family="Arial", xlab="Final exchange rate", xlim=c(0,10), ylim=c(0,15), main="")

	par(old.par)
dev.off()


# no pool outs; ccr mostly in range 4 - 7, last trial is smooth increase

# 2. capped

s_trials <- 100
exc_type <- 9
exc_width <- 12000		# width parameter over which multiplier varies - intended range of pool
exc_greatest <- 5			# controls max size of multiplier (at zero)
exc_peak <- 200			# also controls max size of multiplier (at zero)
exc_damp <- 2000			# overall strength of multiplier over whole range
ccm_start <- 1.2
run_sim()

write.csv(trials, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials2.csv", row.names=FALSE)	# write .csv file
trials2 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials2.csv", head=TRUE)	# read in data file

write.csv(days, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days2.csv", row.names=FALSE)	# write .csv file
days2 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days2.csv", head=TRUE)	# read in data file

trials2$poolmin[trials2$poolmin < 0]
hist(trials2$fccr[trials2$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,10), main="")
hist(trials2$poolmin, breaks=20, xlab="Minimum pool", main="")
hist(trials2$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days2$id, days2$ccr, type="l", main="", xlab="Day", ylab="Exchange rate")
plot(days2$id, days2$pool, type="l", main="", xlab="Day", ylab="Exchange rate")
plot(days2$id, days2$totalcc, type="l", main="", xlab="Day", ylab="Exchange rate")

mean(trials2$fccr)		# 0.9640239
mean(trials2$poolmax)		# 8859.23
mean(trials2$poolmin)		# 743.1991
mean(trials2$totalcc)		# 9938.556
mean(trials2$maxccr)		# 1.194681
mean(trials2$minccr)		# 0.9280865
mean(trials2$aveccr)		# 1.06906
mean(trials2$sd)			# 0.07071842
mean(trials2$fd)			# 1.349302
mean(trials2$runave)		# 0.006012173
mean(trials2$diffave)		# 0.002465554
sum(trials2$poolout)		# 0

sd(trials2$fccr)			# 0.1708221
sd(trials2$maxccr)		# 0.01105366
sd(trials2$minccr)		# 0.1492075
sd(trials2$aveccr)		# 0.08298075
sd(trials2$sd)			# 0.05329204
sd(trials2$fd)			# 0.095036
sd(trials2$runave)		# 0.001274616
sd(trials2$diffave)		# 0.0006132118
sd(trials2$poolmax)		# 858.4804
sd(trials2$poolmin)		# 235.3157
sd(trials2$totalcc)		# 824.2799

tiff("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/Fig 3 capped.tiff", height = 7.5, width = 15, units = 'cm', compression = "lzw", res = 600)
	old.par <- par(no.readonly = TRUE)
	par(cex=0.6)
	par(mar=c(5.1,4.1,2.1,2.1))
	par(yaxp=c(0,1,5))

	hist(trials2$fccr[trials1$poolmin >= 0], breaks=20, family="Arial", xlab="Final exchange rate", xlim=c(0,10), ylim=c(0,15), main="")

	par(old.par)
dev.off()


# no pool outs; fccr is beautifully bunched

# 3. uncapped, less damping

s_trials <- 100
exc_type <- 9
exc_width <- 12000		# width parameter over which multiplier varies - intended range of pool
exc_greatest <- 5			# controls max size of multiplier (at zero)
exc_peak <- 200			# also controls max size of multiplier (at zero)
exc_damp <- 1000			# overall strength of multiplier over whole range
ccm_start <- 10
run_sim()

write.csv(trials, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials3.csv", row.names=FALSE)	# write .csv file
trials3 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials3.csv", head=TRUE)	# read in data file

write.csv(days, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days3.csv", row.names=FALSE)	# write .csv file
days3 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days3.csv", head=TRUE)	# read in data file

trials3$poolmin[trials3$poolmin < 0]
hist(trials3$fccr[trials3$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,10), main="")
hist(trials3$poolmin, breaks=20, xlab="Minimum pool", main="")
hist(trials3$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days3$id, days3$ccr, type="l", main="", xlab="Day", ylab="Exchange rate")
plot(days3$id, days3$pool, type="l", main="", xlab="Day", ylab="Pool CC")
plot(days3$id, days3$totalcc, type="l", main="", xlab="Day", ylab="Total CC issued")

mean(trials3$fccr)		# 5.428557
mean(trials3$poolmax)		# 4977.253
mean(trials3$poolmin)		# 330.5978
mean(trials3$totalcc)		# 5000
mean(trials3$maxccr)		# 5.448554
mean(trials3$minccr)		# 1
mean(trials3$aveccr)		# 2.579215
mean(trials3$sd)			# 1.261133
mean(trials3$fd)			# 1.131474
mean(trials3$runave)		# 0.03484246
mean(trials3$diffave)		# 0.01207915
sum(trials3$poolout)		# 0

# no pool outs; more spread out than before, but still no new minted (rate stayed under 10)

# 4. capped, less damping

s_trials <- 100
exc_type <- 9
exc_width <- 12000		# width parameter over which multiplier varies - intended range of pool
exc_greatest <- 5			# controls max size of multiplier (at zero)
exc_peak <- 200			# also controls max size of multiplier (at zero)
exc_damp <- 1000			# overall strength of multiplier over whole range
ccm_start <- 1.2
run_sim()

write.csv(trials, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials4.csv", row.names=FALSE)	# write .csv file
trials4 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials4.csv", head=TRUE)	# read in data file

write.csv(days, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days4.csv", row.names=FALSE)	# write .csv file
days4 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days4.csv", head=TRUE)	# read in data file

trials4$poolmin[trials4$poolmin < 0]
hist(trials4$fccr[trials4$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,10), main="")
hist(trials4$poolmin, breaks=20, xlab="Minimum pool", main="")
hist(trials4$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days4$id, days4$ccr, type="l", main="", xlab="Day", ylab="Exchange rate")
plot(days4$id, days4$pool, type="l", main="", xlab="Day", ylab="Pool CC")
plot(days4$id, days4$totalcc, type="l", main="", xlab="Day", ylab="Issued CC")

mean(trials4$fccr)		# 1.052175
mean(trials4$poolmax)		# 8354.165
mean(trials4$poolmin)		# 850.6489
mean(trials4$totalcc)		# 9447.444
mean(trials4$maxccr)		# 1.197608
mean(trials4$minccr)		# 0.984356
mean(trials4$aveccr)		# 1.109436
mean(trials4$sd)			# 0.04719194
mean(trials4$fd)			# 1.465183
mean(trials4$runave)		# 0.009942437
mean(trials4$diffave)		# 0.004507351
sum(trials4$poolout)		# 0

# no pool outs; very nicely bunched; rise and fall can happen


5. capped, really high damping

s_trials <- 100
exc_type <- 9
exc_width <- 12000		# width parameter over which multiplier varies - intended range of pool
exc_greatest <- 5			# controls max size of multiplier (at zero)
exc_peak <- 200			# also controls max size of multiplier (at zero)
exc_damp <- 4000			# overall strength of multiplier over whole range
ccm_start <- 1.2
run_sim()

write.csv(trials, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials5.csv", row.names=FALSE)	# write .csv file
trials5 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials5.csv", head=TRUE)	# read in data file

write.csv(days, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days5.csv", row.names=FALSE)	# write .csv file
days5 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days5.csv", head=TRUE)	# read in data file

trials5$poolmin[trials5$poolmin < 0]
hist(trials5$fccr[trials5$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,10), main="")
hist(trials5$poolmin, breaks=20, xlab="Minimum pool", main="")
hist(trials5$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days5$id, days5$ccr, type="l", main="", xlab="Day", ylab="Exchange rate")
plot(days5$id, days5$pool, type="l", main="", xlab="Day", ylab="Pool CC")
plot(days5$id, days5$totalcc, type="l", main="", xlab="Day", ylab="Total CC issued")

mean(trials5$fccr)		# 0.7706206
mean(trials5$poolmax)		# 9818.149
mean(trials5$poolmin)		# 711.3259
mean(trials5$totalcc)		# 10903.91
mean(trials5$maxccr)		# 1.194327
mean(trials5$minccr)		# 0.7568385
mean(trials5$aveccr)		# 0.9646235
mean(trials5$sd)			# 0.1347951
mean(trials5$fd)			# 1.17001
mean(trials5$runave)		# 0.007342815
mean(trials5$diffave)		# 0.001599585
sum(trials5$poolout)		# 0



6. capped, extremely high damping

s_trials <- 100
exc_type <- 9
exc_width <- 12000		# width parameter over which multiplier varies - intended range of pool
exc_greatest <- 5			# controls max size of multiplier (at zero)
exc_peak <- 200			# also controls max size of multiplier (at zero)
exc_damp <- 8000			# overall strength of multiplier over whole range
ccm_start <- 1.2
run_sim()

write.csv(trials, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials6.csv", row.names=FALSE)	# write .csv file
trials6 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials6.csv", head=TRUE)	# read in data file

write.csv(days, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days6.csv", row.names=FALSE)	# write .csv file
days6 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days6.csv", head=TRUE)	# read in data file

trials6$poolmin[trials6$poolmin < 0]
hist(trials6$fccr[trials6$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,10), main="")
hist(trials6$poolmin, breaks=20, xlab="Minimum pool", main="")
hist(trials6$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days6$id, days6$ccr, type="l", main="", xlab="Day", ylab="Exchange rate")
plot(days6$id, days6$pool, type="l", main="", xlab="Day", ylab="Pool CC")
plot(days6$id, days6$totalcc, type="l", main="", xlab="Day", ylab="Total CC issued")

mean(trials6$fccr)		# 0.4917365
mean(trials6$poolmax)		# 11103.95
mean(trials6$poolmin)		# 742.9591
mean(trials6$totalcc)		# 12148.17
mean(trials6$maxccr)		# 1.19722
mean(trials6$minccr)		# 0.4886261
mean(trials6$aveccr)		# 0.790914
mean(trials6$sd)			# 0.2325412
mean(trials6$fd)			# 1.035194
mean(trials6$runave)		# 0.02252258
mean(trials6$diffave)		# 0.00139821
sum(trials6$poolout)		# 0


7. capped, extremely low damping

s_trials <- 100
exc_type <- 9
exc_width <- 12000		# width parameter over which multiplier varies - intended range of pool
exc_greatest <- 5			# controls max size of multiplier (at zero)
exc_peak <- 200			# also controls max size of multiplier (at zero)
exc_damp <- 500			# overall strength of multiplier over whole range
ccm_start <- 1.2
run_sim()

write.csv(trials, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials7.csv", row.names=FALSE)	# write .csv file
trials7 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials7.csv", head=TRUE)	# read in data file

write.csv(days, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days7.csv", row.names=FALSE)	# write .csv file
days7 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days7.csv", head=TRUE)	# read in data file

trials7$poolmin[trials7$poolmin < 0]
hist(trials7$fccr[trials7$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,10), main="")
hist(trials7$poolmin, breaks=20, xlab="Minimum pool", main="")
hist(trials7$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days7$id, days7$ccr, type="l", main="", xlab="Day", ylab="Exchange rate")
plot(days7$id, days7$pool, type="l", main="", xlab="Day", ylab="Pool CC")
plot(days7$id, days7$totalcc, type="l", main="", xlab="Day", ylab="Total CC issued")

mean(trials7$fccr)		# 1.084531
mean(trials7$poolmax)		# 8107.531
mean(trials7$poolmin)		# 1065.943
mean(trials7$totalcc)		# 8107.531
mean(trials7$maxccr)		# 1.206462
mean(trials7$minccr)		# 0.9970929
mean(trials7$aveccr)		# 1.120198
mean(trials7$sd)			# 0.04156629
mean(trials7$fd)			# 1.522087
mean(trials7$runave)		# 0.01778869
mean(trials7$diffave)		# 0.008876847
sum(trials7$poolout)		# 0







hist(trials$fccr[trials$poolmin >= 0], breaks=20, xlab="Final exchange rate", ylim=c(0,15), main="")
hist(trials$poolmin, breaks=20, xlab="Minimum pool", main="")
trials$poolmin[trials$poolmin < 0]
hist(trials$poolmax, breaks=20, xlab="Maximum pool", main="")

big_conc <- function(vs) {
	x <- c()
	for (i in 1:length(vs)) {
		x <- c(x,vs[[i]])
	}
	return(x)
}

plot(density(big_conc(trials$runs)))
max(big_conc(trials$runs))
hist(big_conc(trials$runs), breaks=1000)



# plot the exc_type rule

# update_ccr(ccr, ex, pool, type)

x <- matrix(nrow=35, ncol=5)
for (i in 1:5) {
	for (j in 1:35) {
		x[j,i] <- update_ccr(1,-3000 + 1500*(i-1), 0 + 200*(j-1),9)
	}
}

plot(seq(from=0, to=6800, by=200), x[,1], type="o", pch="-", lty=3, xlab="Pool", ylab="Multiplier", ylim=c(0.8,1.2))
lines(seq(from=0, to=6800, by=200), x[,2], type="o", pch="-", lty=2)
lines(seq(from=0, to=6800, by=200), x[,3], type="o", pch=19, lty=1)
lines(seq(from=0, to=6800, by=200), x[,4], type="o", pch="+", lty=2)
lines(seq(from=0, to=6800, by=200), x[,5], type="o", pch="+", lty=3)
legend("topright", lty=c(3,2,1,2,3), lwd=c(1,1,1,1,1), pch=c("+","+",19,"-","-"), c("D-S=3,000", "D-S=1,500", "D-S=0", "D-S=-1,500", "D-S=-3,000"))


tiff("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/Fig 1 rule curves.tiff", height = 7.5, width = 15, units = 'cm', compression = "lzw", res = 600)
	old.par <- par(no.readonly = TRUE)
	par(cex=0.6)
	par(mar=c(5.1,4.1,2.1,2.1))
	par(yaxp=c(0,1,5))

	x <- matrix(nrow=65, ncol=5)
	for (i in 1:5) {
		for (j in 1:65) {
			x[j,i] <- update_ccr(1,-3000 + 1500*(i-1), 0 + 200*(j-1),9)
		}
	}

	plot(seq(from=0, to=12800, by=200), x[,1], family="Arial", type="l", lty=3, lwd=1, xlab="Pool", ylab="Multiplier", ylim=c(0.9,1.1))
	lines(seq(from=0, to=12800, by=200), x[,2], family="Arial", type="l", lty=2, lwd=1)
	lines(seq(from=0, to=12800, by=200), x[,3], family="Arial", type="l", lty=1, lwd=2)
	lines(seq(from=0, to=12800, by=200), x[,4], family="Arial", type="l", lty=2, lwd=2)
	lines(seq(from=0, to=12800, by=200), x[,5], family="Arial", type="l", lty=3, lwd=2)
	legend("topright", lty=c(3,2,1,2,3), lwd=c(2,2,2,1,1), c("D-S=3,000", "D-S=1,500", "D-S=0", "D-S=-1,500", "D-S=-3,000"))
	par(old.par)
dev.off()






tiff("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/Fig 4 fd trend.tiff", height = 7.5, width = 15, units = 'cm', compression = "lzw", res = 600)
	old.par <- par(no.readonly = TRUE)
	par(cex=0.6)
	par(mar=c(5.1,4.1,2.1,2.1))
	par(yaxp=c(0,1,5))

	fd <- c(1.035194, 1.17001, 1.349302, 1.465183, 1.522087)
	ap <- c(8000, 4000, 2000, 1000, 500)
	plot(ap, fd, type="o", family="Arial", xlab="Attentuation", ylab="Mean Fractal Dimension")


	par(old.par)
dev.off()


tiff("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/Fig 5 fccr trend.tiff", height = 7.5, width = 15, units = 'cm', compression = "lzw", res = 600)
	old.par <- par(no.readonly = TRUE)
	par(cex=0.6)
	par(mar=c(5.1,4.1,2.1,2.1))
	par(yaxp=c(0,1,5))

	fr <- c(0.4917365, 0.7706206, 0.9640239, 1.052175, 1.084531)
	ap <- c(8000, 4000, 2000, 1000, 500)
	plot(ap, fr, type="o", family="Arial", xlab="Attentuation", ylab="Mean final exchange rate")


	par(old.par)
dev.off()







write.csv(trials, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials no controls.csv", row.names=FALSE)	# write .csv file
trials2 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials no controls.csv", head=TRUE)	# read in data file


tiff("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/Fig 1 without control 1 ccr distrib.tiff", height = 7.5, width = 15, units = 'cm', compression = "lzw", res = 600)
	old.par <- par(no.readonly = TRUE)
	par(cex=0.6)
	par(mar=c(5.1,4.1,2.1,2.1))
	par(yaxp=c(0,1,5))

	hist(trials2$fccr[trials2$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,3), ylim=c(0,15), main="")

	par(old.par)
dev.off()

# 2. 100 trials with low minting cost (to cap the rate at 1.2)

# parameters as before, but with one change:

ccm_start <- 1.2
run_sim()

hist(trials$fccr[trials$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,3), ylim=c(0,15), main="")
hist(trials$poolmin, breaks=40, xlab="Minimum pool", main="")
trials$poolmin[trials$poolmin < 0]
hist(trials$poolmax, breaks=20, xlab="Maximum pool", main="")
hist(big_conc(trials$runs), breaks=1000, xlim=c(0,0.2))

plot(days$ccr, type="l")
plot(days$pool, type="l")



write.csv(trials, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials capped.csv", row.names=FALSE)	# write .csv file
trials3 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/trials capped.csv", head=TRUE)	# read in data file

tiff("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/Fig 2 with cap 1 ccr distrib.tiff", height = 7.5, width = 15, units = 'cm', compression = "lzw", res = 600)
	old.par <- par(no.readonly = TRUE)
	par(cex=0.6)
	par(mar=c(5.1,4.1,2.1,2.1))
	par(yaxp=c(0,1,5))

	hist(trials3$fccr[trials3$poolmin >= 0], breaks=20, xlab="Final exchange rate", xlim=c(0,3), ylim=c(0,15), main="")

	par(old.par)
dev.off()

write.csv(days, "REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days capped.csv", row.names=FALSE)	# write .csv file
days3 <- read.csv("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/days capped.csv", head=TRUE)	# read in data file

tiff("REPLACE THIS TEXT WITH THE PATH YOU WANT TO USE/Fig 3 individual capped.tiff", height = 7.5, width = 15, units = 'cm', compression = "lzw", res = 600)
	old.par <- par(no.readonly = TRUE)
	par(cex=0.6)
	par(mar=c(5.1,4.1,2.1,2.1))
	par(yaxp=c(0,1,5))

	plot(days3$ccr, type="l", xlab="Days", ylim=c(0.9,1.25), ylab="Exchange rate")

	par(old.par)
dev.off()

plot(days3$totalcc, type="l", xlab="Days", ylab="Total CC")	# shows release of CC at peak points


3.  100 trials with low minting cost (to cap the rate at 1.2) and rule 

exc_type <- 9
ccm_start <- 1.2
run_sim()



4. 100 trials

exc_type <- 9
ccm_start <- 10
run_sim()

hist(trials$fccr[trials$poolmin >= 0], breaks=100, xlab="Final exchange rate", main="")
hist(trials$poolmin, breaks=20, xlab="Minimum pool", main="")
trials$poolmin[trials$poolmin < 0]
hist(trials$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days$ccr, type="l")
plot(days$totalcc, type="l")


5. Try a more reactive, short term population of participants

rcncy <- c(0,0.1)			# range for recency factors
ccm_start <- 1.2
exc_type <- 9
run_sim()


hist(trials$fccr[trials$poolmin >= 0], breaks=100, xlab="Final exchange rate", main="")
hist(trials$poolmin, breaks=20, xlab="Minimum pool", main="")
trials$poolmin[trials$poolmin < 0]
hist(trials$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days$ccr, type="l")
plot(days$totalcc, type="l")

hist(big_conc(trials$runs), breaks=1000)


6. Try a more reactive, short term population of participants

rcncy <- c(0,0.1)			# range for recency factors
ccm_start <- 10
exc_type <- 9
run_sim()


hist(trials$fccr[trials$poolmin >= 0], breaks=100, xlab="Final exchange rate", main="")
hist(trials$poolmin, breaks=20, xlab="Minimum pool", main="")
trials$poolmin[trials$poolmin < 0]
hist(trials$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days$ccr, type="l")
plot(days$totalcc, type="l")
plot(days$pool, type="l")


7. Try a medium reactive rule

ccm_start <- 10
exc_type <- 11
run_sim()


hist(trials$fccr[trials$poolmin >= 0], breaks=100, xlab="Final exchange rate", main="")
hist(trials$poolmin, breaks=20, xlab="Minimum pool", main="")
trials$poolmin[trials$poolmin < 0]
hist(trials$poolmax, breaks=20, xlab="Maximum pool", main="")

plot(days$ccr, type="l")
plot(days$totalcc, type="l")
plot(days$pool, type="l")


8. 

ccm_start <- 1.2
exc_type <- 11
run_sim()

9.

ccm_start <- 1.2
exc_type <- 12
run_sim()


10.
ccm_start <- 1.2
exc_type <- 13
run_sim()

11.
ccm_start <- 1.2
exc_type <- 14
run_sim()



table_freq <- function(vs) {	# concatenates the vectors in the vector of vectors vs then returns table of frequencies
	x <- c()
	for (i in 1:length(vs)) {
		x <- c(x,vs[[i]])
	}
	return(table(x))
}




plot(days$id, days$ccheldbyRE, type="l", main="CC held x relative entropy (excluding exchange)", xlab="Days", ylab="adj CC")
plot(days$id, days$purchbyRE, type="l", main="Commercial activity x relative entropy (excluding exchange)", xlab="Days", ylab="adj CC")
plot(days$id, days$excbyRE, type="l", main="Exchange activity x relative entropy", xlab="Days", ylab="adj CC")
plot(days$id, days$merccex + days$cusccex, type="l", main="Merchant + customer exchange total", xlab="Days", ylab="adj CC")
plot(days$id, days$cusin + days$merin, type="l", main="Customers and merchants participating", xlab="Days", ylab="Count")
plot(days$id,days$purchRE, type="l", main="Relative entropy of CC purchases", xlab="Days", ylab="RE")
plot(days$id,days$heldRE, type="l", main="Relative entropy of CC holdings", xlab="Days", ylab="RE")







